Newsync Installation & Database Guide
=====================================

Overview
--------
Newsync provides an optional indexed database table to map remote item GUIDs to local post IDs. This indexed table greatly improves lookup speed compared to searching postmeta (`_newssync_guid`) and is recommended for high-traffic or large sites. If the table cannot be created due to host restrictions the plugin will continue to work using the legacy postmeta fallback.

Safety first
------------
- Always backup your database before performing schema changes or migrations.
- The migration process is optional and should only be run after the table exists.

Create the table (WP-CLI)
-------------------------
From your site root run:

```bash
wp plugin activate rss-newssync
# verify the helper exists
wp eval 'var_dump(function_exists("newssync_create_item_map_table"));'
# attempt table creation
wp eval 'var_dump(newssync_create_item_map_table());'
# verify table exists (replace wp_ with your DB prefix)
wp db query "SHOW TABLES LIKE 'wp_newssync_item_map';"
```

Create the table (manual SQL)
-----------------------------
If your host cannot run WP-CLI, create the table manually in your database admin tool (phpMyAdmin, Adminer, MySQL client). Replace `wp_` with your table prefix:

```sql
CREATE TABLE `wp_newssync_item_map` (
  id BIGINT unsigned NOT NULL AUTO_INCREMENT,
  guid VARCHAR(191) NOT NULL,
  post_id BIGINT unsigned NOT NULL,
  feed_slug VARCHAR(128) NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY guid (guid),
  KEY post_id (post_id)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

Migrate legacy postmeta
-----------------------
After the table exists, migrate existing `_newssync_guid` postmeta entries to the indexed table using WP-CLI:

```bash
wp newssync migrate-item-map --batch=200
```

Adjust `--batch` to fit your server resources. Back up the DB first.

Verification & troubleshooting
------------------------------
- Verify table existence using `wp db query "SHOW TABLES LIKE 'wp_newssync_item_map';"` or your DB admin.
- If table creation fails, the DB user likely lacks `CREATE` / `ALTER` privileges — contact your host or run the SQL manually.
- If migration fails due to timeouts, reduce `--batch` and retry.

Notes for hosts and admins
-------------------------
- The plugin will not break if the table cannot be created — it will silently fall back to postmeta storage. However, performance will be worse on large datasets.
- Consider adding a scheduled check or running the migration during maintenance windows for busy sites.

Support
-------
If you need help, provide your host with the SQL above and the steps to run the WP-CLI commands. For plugin issues, use the plugin support channels and include details about your DB user privileges and any error messages received.