<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Admin page: Newssync Table Creation & Migration Guide
 * English content, translatable strings.
 */

if ( ! current_user_can( 'manage_options' ) ) {
    return;
}
?>
<div class="wrap">
    <h1><?php echo esc_html__( 'NewsSync: Optimized Table & Migration', 'rss-newssync' ); ?></h1>

    <p><?php echo esc_html__( 'NewsSync can use an indexed database table to map remote item GUIDs to local post IDs. This improves lookup speed compared to postmeta searches and is recommended for large or high-traffic sites. If the table cannot be created due to database privileges, the plugin will continue using the legacy postmeta fallback (_newssync_guid).', 'rss-newssync' ); ?></p>

    <h2><?php echo esc_html__( 'Create the table (WP-CLI)', 'rss-newssync' ); ?></h2>
    <p><?php echo esc_html__( 'From the WordPress site root run the following commands. These require WP-CLI and a DB user with CREATE/ALTER privileges.', 'rss-newssync' ); ?></p>
    <pre><code>wp plugin activate rss-newssync
wp eval 'var_dump(function_exists("newssync_create_item_map_table"));'
wp eval 'var_dump(newssync_create_item_map_table());'
wp db query "SHOW TABLES LIKE 'wp_newssync_item_map';"</code></pre>

    <h2><?php echo esc_html__( 'Create the table (manual SQL)', 'rss-newssync' ); ?></h2>
    <p><?php echo esc_html__( 'Run the SQL below in your database admin tool (replace `wp_` with your table prefix):', 'rss-newssync' ); ?></p>
    <pre><code>CREATE TABLE `wp_newssync_item_map` (
  id BIGINT unsigned NOT NULL AUTO_INCREMENT,
  guid VARCHAR(191) NOT NULL,
  post_id BIGINT unsigned NOT NULL,
  feed_slug VARCHAR(128) NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY guid (guid),
  KEY post_id (post_id)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;</code></pre>

    <h2><?php echo esc_html__( 'Migrate legacy postmeta to the indexed table', 'rss-newssync' ); ?></h2>
    <p><?php echo esc_html__( 'After the table exists you can migrate `_newssync_guid` postmeta entries into the indexed table. Always backup the database before migrating.', 'rss-newssync' ); ?></p>
    <pre><code>wp newssync migrate-item-map --batch=200</code></pre>
    <p><?php echo esc_html__( 'Lower the `--batch` size if you encounter timeouts.', 'rss-newssync' ); ?></p>

    <h2><?php echo esc_html__( 'Verification & troubleshooting', 'rss-newssync' ); ?></h2>
    <ul>
        <li><?php echo esc_html__( 'Check table existence via your DB tool or:', 'rss-newssync' ); ?> <code>wp db query "SHOW TABLES LIKE 'wp_newssync_item_map'"</code></li>
        <li><?php echo esc_html__( 'If creation fails the DB user probably lacks CREATE/ALTER privileges. Contact your host or create the table manually.', 'rss-newssync' ); ?></li>
        <li><?php echo esc_html__( 'If migration fails due to timeouts, reduce the batch size and retry.', 'rss-newssync' ); ?></li>
    </ul>

    <p style="text-align:center; font-size:1.1em;">
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=rss-newssync' ) ); ?>" class="button button-secondary"><?php echo esc_html__( 'Back to RSS NewsSync', 'rss-newssync' ); ?></a>
    </p>
</div>
