<?php
/**
 * NewsSync Documentation Section
 * Complete documentation for shortcode parameters
 *
 * @package NewsSync
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<!-- Documentation Section -->
<div class="newssync-content-section" data-section="documentation" style="display:none;">
    <script>console.log('NewsSync: server included documentation section');</script>

    <div style="background:#fff; padding:35px; border-radius:12px; box-shadow:0 4px 25px rgba(0,0,0,0.08); max-width:1100px;">

        <h1><?php esc_html_e( 'RSS NewsSync – Complete Documentation', 'rss-newssync' ); ?></h1>

        <h2><?php esc_html_e( '1. Basic Shortcode', 'rss-newssync' ); ?></h2>
        <pre style="background:#f0f0f0; padding:18px; border-radius:8px; font-size:1.1em;">[newssync]</pre>
        <p><?php esc_html_e( 'Uses your default settings from the admin panel.', 'rss-newssync' ); ?></p>

        <h2><?php esc_html_e( '2. Main Parameters (work in ALL layouts)', 'rss-newssync' ); ?></h2>
        <table class="widefat fixed" style="margin:20px 0;">
            <thead>
                <tr>
                    <th><?php esc_html_e( 'Parameter', 'rss-newssync' ); ?></th>
                    <th><?php esc_html_e( 'Example', 'rss-newssync' ); ?></th>
                    <th><?php esc_html_e( 'Description', 'rss-newssync' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><code>layout</code></td>
                    <td><code>grid</code>, <code>list</code>, <code>carousel</code>, <code>hero</code>, <code>minimal</code></td>
                    <td><?php esc_html_e( 'Choose the visual style', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>limit</code></td>
                    <td><code>limit="6"</code></td>
                    <td><?php esc_html_e( 'Maximum number of items (Hero/Carousel limited to 6)', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>category</code></td>
                    <td><code>category="CNBC"</code></td>
                    <td><?php esc_html_e( 'Show only one source (must match the category name you set)', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>source</code></td>
                    <td><code>source="posts"</code></td>
                    <td><?php esc_html_e( 'Use imported posts instead of live RSS', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>autoplay</code></td>
                    <td><code>autoplay="on"</code></td>
                    <td><?php esc_html_e( 'Enable/disable carousel autoplay (on/off)', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>cache_ttl</code></td>
                    <td><code>cache_ttl="3600"</code></td>
                    <td><?php esc_html_e( 'Cache duration in seconds (overrides global setting)', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>orderby</code></td>
                    <td><code>orderby="date"</code></td>
                    <td><?php esc_html_e( 'Order by date or title', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>order</code></td>
                    <td><code>order="DESC"</code></td>
                    <td><?php esc_html_e( 'Sort order: DESC (newest first) or ASC (oldest first)', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>offset</code></td>
                    <td><code>offset="3"</code></td>
                    <td><?php esc_html_e( 'Skip first N items', 'rss-newssync' ); ?> <em style="color:#d63638;"><?php esc_html_e( '(limited in FREE version due to per-feed restrictions)', 'rss-newssync' ); ?></em></td>
                </tr>
            </tbody>
        </table>

        <h2><?php esc_html_e( '3. List Mode (only when layout="list")', 'rss-newssync' ); ?></h2>
        <ul style="font-size:1.1em; line-height:1.8;">
            <li><code>list_mode="standard"</code> → <?php esc_html_e( 'Classic list with image', 'rss-newssync' ); ?></li>
            <li><code>list_mode="minimal"</code> → <?php esc_html_e( 'Ultra-compact (title + time + source)', 'rss-newssync' ); ?></li>
            <li><code>list_mode="custom"</code> → <?php esc_html_e( 'Full control!', 'rss-newssync' ); ?></li>
        </ul>

        <h2><?php esc_html_e( '4. CUSTOM MODE – Full Control', 'rss-newssync' ); ?></h2>
        <p><?php esc_html_e( 'Use', 'rss-newssync' ); ?> <code>list_mode="custom"</code> <?php esc_html_e( 'and combine any of these parameters:', 'rss-newssync' ); ?></p>
        <pre style="background:#222; color:#0f0; padding:20px; border-radius:10px; font-size:0.95em; line-height:1.6;">[newssync layout="list" list_mode="custom"
 limit="8"
 category="CNN"
 show_image="no"
 show_excerpt="yes"
 excerpt_length="20"
 show_date="yes"
 show_source="yes"
 date_format="H:i - d/m"
 show_readmore="yes"
 compact="yes"]</pre>

        <h3><?php esc_html_e( 'All available parameters:', 'rss-newssync' ); ?></h3>
        <table class="widefat" style="margin:25px 0;">
            <thead>
                <tr>
                    <th style="width:35%;"><?php esc_html_e( 'Parameter', 'rss-newssync' ); ?></th>
                    <th><?php esc_html_e( 'Description', 'rss-newssync' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><code>show_title="yes/no"</code></td>
                    <td><?php esc_html_e( 'Show/hide title', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>show_image="yes/no"</code></td>
                    <td><?php esc_html_e( 'Show/hide image', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>hide_image="yes/no"</code></td>
                    <td><?php esc_html_e( 'Alternative way to hide images (same as show_image="no")', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>show_excerpt="yes/no"</code></td>
                    <td><?php esc_html_e( 'Show/hide description', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>show_date="yes/no"</code></td>
                    <td><?php esc_html_e( 'Show/hide date/time', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>show_source="yes/no"</code></td>
                    <td><?php esc_html_e( 'Show/hide source (CNBC, etc.)', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>show_readmore="yes/no"</code></td>
                    <td><?php esc_html_e( 'Show "Read more" link', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>compact="yes"</code></td>
                    <td><?php esc_html_e( 'Ultra-compact layout (perfect for 30% columns)', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><code>date_format="H:i - d/m"</code></td>
                    <td><?php esc_html_e( 'Any PHP date format', 'rss-newssync' ); ?> (<a href="https://www.php.net/manual/en/datetime.format.php" target="_blank">ver formatos</a>)</td>
                </tr>
                <tr>
                    <td><code>excerpt_length="20"</code></td>
                    <td><?php esc_html_e( 'Maximum number of words in excerpt (max 25)', 'rss-newssync' ); ?></td>
                </tr>
            </tbody>
        </table>

        <hr style="margin: 40px 0; border: 0; border-top: 2px solid #ddd;">

        <h2><?php esc_html_e( '5. Complete Examples', 'rss-newssync' ); ?></h2>

        <div style="background:#f9f9f9; padding:20px; border-radius:8px; margin:20px 0;">
            <h3 style="margin-top:0; color:#2271b1;"><?php esc_html_e( 'Example 1: Grid with 6 items', 'rss-newssync' ); ?></h3>
            <pre style="background:#fff; padding:15px; border-left:4px solid #2271b1;">[newssync layout="grid" limit="6"]</pre>
        </div>

        <div style="background:#f9f9f9; padding:20px; border-radius:8px; margin:20px 0;">
            <h3 style="margin-top:0; color:#2271b1;"><?php esc_html_e( 'Example 2: Carousel with autoplay', 'rss-newssync' ); ?></h3>
            <pre style="background:#fff; padding:15px; border-left:4px solid #2271b1;">[newssync layout="carousel" autoplay="on" limit="6"]</pre>
        </div>

        <div style="background:#f9f9f9; padding:20px; border-radius:8px; margin:20px 0;">
            <h3 style="margin-top:0; color:#2271b1;"><?php esc_html_e( 'Example 3: List with specific source', 'rss-newssync' ); ?></h3>
            <pre style="background:#fff; padding:15px; border-left:4px solid #2271b1;">[newssync layout="list" category="BBC News" limit="10"]</pre>
        </div>

        <div style="background:#f9f9f9; padding:20px; border-radius:8px; margin:20px 0;">
            <h3 style="margin-top:0; color:#2271b1;"><?php esc_html_e( 'Example 4: Ultra-compact sidebar', 'rss-newssync' ); ?></h3>
            <pre style="background:#fff; padding:15px; border-left:4px solid #2271b1;">[newssync layout="minimal" limit="5"]</pre>
        </div>

        <div style="background:#f9f9f9; padding:20px; border-radius:8px; margin:20px 0;">
            <h3 style="margin-top:0; color:#2271b1;"><?php esc_html_e( 'Example 5: Custom list without images', 'rss-newssync' ); ?></h3>
            <pre style="background:#fff; padding:15px; border-left:4px solid #2271b1;">[newssync layout="list" list_mode="custom" show_image="no" show_date="yes" show_source="yes" compact="yes"]</pre>
        </div>

        <div style="background:#f9f9f9; padding:20px; border-radius:8px; margin:20px 0;">
            <h3 style="margin-top:0; color:#2271b1;"><?php esc_html_e( 'Example 6: Hero banner', 'rss-newssync' ); ?></h3>
            <pre style="background:#fff; padding:15px; border-left:4px solid #2271b1;">[newssync layout="hero" limit="3"]</pre>
        </div>

        <div style="background:#f9f9f9; padding:20px; border-radius:8px; margin:20px 0;">
            <h3 style="margin-top:0; color:#2271b1;"><?php esc_html_e( 'Example 7: Using imported posts', 'rss-newssync' ); ?></h3>
            <pre style="background:#fff; padding:15px; border-left:4px solid #2271b1;">[newssync source="posts" limit="8" layout="grid"]</pre>
            <p style="margin-bottom:0;"><em><?php esc_html_e( 'Requires "Save RSS Items as Posts" enabled in Settings', 'rss-newssync' ); ?></em></p>
        </div>

        <hr style="margin: 40px 0; border: 0; border-top: 2px solid #ddd;">

        <h2><?php esc_html_e( '6. Layout Comparison', 'rss-newssync' ); ?></h2>
        <table class="widefat" style="margin:25px 0;">
            <thead>
                <tr>
                    <th style="width:20%;"><?php esc_html_e( 'Layout', 'rss-newssync' ); ?></th>
                    <th style="width:40%;"><?php esc_html_e( 'Best For', 'rss-newssync' ); ?></th>
                    <th style="width:40%;"><?php esc_html_e( 'Characteristics', 'rss-newssync' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><strong>Grid</strong></td>
                    <td><?php esc_html_e( 'Main content areas, magazine style', 'rss-newssync' ); ?></td>
                    <td><?php esc_html_e( 'Responsive columns, images, excerpts', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><strong>List</strong></td>
                    <td><?php esc_html_e( 'Archives, news feeds, blog lists', 'rss-newssync' ); ?></td>
                    <td><?php esc_html_e( 'Vertical list, customizable fields', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><strong>Carousel</strong></td>
                    <td><?php esc_html_e( 'Featured content, homepage highlights', 'rss-newssync' ); ?></td>
                    <td><?php esc_html_e( 'Sliding items, autoplay, navigation', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><strong>Hero</strong></td>
                    <td><?php esc_html_e( 'Top banner, breaking news', 'rss-newssync' ); ?></td>
                    <td><?php esc_html_e( 'Large images, prominent headlines', 'rss-newssync' ); ?></td>
                </tr>
                <tr>
                    <td><strong>Minimal</strong></td>
                    <td><?php esc_html_e( 'Sidebars, widgets, compact spaces', 'rss-newssync' ); ?></td>
                    <td><?php esc_html_e( 'Title + date + source only, no images', 'rss-newssync' ); ?></td>
                </tr>
            </tbody>
        </table>

        <hr style="margin: 40px 0; border: 0; border-top: 2px solid #ddd;">

        <div style="background:#e7f3ff; border-left:4px solid #2271b1; padding:20px; margin:30px 0;">
            <h3 style="margin-top:0;"><?php esc_html_e( '💡 Pro Tip: Combining Parameters', 'rss-newssync' ); ?></h3>
            <p style="margin-bottom:0;"><?php esc_html_e( 'You can combine multiple parameters to create exactly the layout you need. Start with a basic layout, then add customizations one by one until you get the perfect result!', 'rss-newssync' ); ?></p>
        </div>

    </div>
</div>
