<?php
/**
 * NewsSync Feeds Section
 * Manage RSS feeds (add, edit, reorder, delete)
 *
 * @package NewsSync
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$feeds = get_option( 'newssync_feeds', array() );
?>

<!-- Feeds Section -->
<div class="newssync-content-section newssync-section" data-section="feeds" style="display:none;">
    <script>console.log('NewsSync: server included feeds section');</script>
    <form method="post" id="rsp-feeds-form" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
        <?php wp_nonce_field( 'newssync_save_feeds_action', 'newssync_feeds_nonce' ); ?>
        <input type="hidden" name="action" value="newssync_save_feeds">
        <input type="hidden" name="newssync_current_tab" value="general">

            <div id="rsp-feeds-sortable" style="margin-bottom:20px;">
                <?php if ( empty( $feeds ) ) : ?>
                    <div style="padding:30px; text-align:center; background:#f9f9f9; border:2px dashed #ccc; border-radius:8px; color:#666;">
                        <?php esc_html_e( 'No feeds added yet. Click "Add Feed" to start!', 'rss-newssync' ); ?>
                    </div>
                <?php else : foreach ( $feeds as $newssync_index => $newssync_feed ) : ?>
                    <div class="rsp-feed-item" draggable="true" style="display:flex; align-items:center; gap:12px; padding:10px; margin:8px 0; background:#fff; border:1px solid #ddd; border-radius:8px;">
                        <span class="dashicons dashicons-menu" style="font-size:20px; color:#999;"></span>
                        <input type="url" name="feed_url[<?php echo intval( $newssync_index ); ?>]" value="<?php echo esc_attr( $newssync_feed['url'] ); ?>" style="flex:2; min-width:0;" required>
                        <input type="text" name="feed_category[<?php echo intval( $newssync_index ); ?>]" value="<?php echo esc_attr( $newssync_feed['category'] ); ?>" placeholder="<?php esc_attr_e( 'Category', 'rss-newssync' ); ?>" style="flex:1; min-width:0;" required>
                        <button type="button" class="button rsp-remove-feed" style="color:#a00; border-color:#a00;"><?php esc_html_e( 'Remove', 'rss-newssync' ); ?></button>
                    </div>
                <?php endforeach; endif; ?>
            </div>

            <p>
                <button type="button" class="button" id="rsp-add-feed"><?php esc_html_e( 'Add Feed', 'rss-newssync' ); ?></button>
                <input type="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Feeds & Order', 'rss-newssync' ); ?>">
                <?php if ( ! empty( $feeds ) ) : ?>
                    <span style="margin-left:15px; color:#2271b1; font-weight:600;"><?php esc_html_e( 'Drag and drop to reorder', 'rss-newssync' ); ?></span>
                <?php endif; ?>
            </p>
        </form>
</div>
