<?php
/**
 * NewsSync Hub/Dashboard Section
 * Getting started wizard and quick stats
 *
 * @package NewsSync
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<!-- Hub Section -->
<div class="newssync-content-section" data-section="hub" style="display:none;">
    <script>console.log('NewsSync: server included hub section');</script>
    <div class="newssync-wizard">
        <h3 class="newssync-wizard-title"><?php esc_html_e( 'Getting Started - Follow these 3 steps:', 'rss-newssync' ); ?></h3>

        <div class="newssync-step">
            <div class="newssync-step-number">1</div>
            <div class="newssync-step-content">
                <p class="newssync-step-text">
                    <?php
                    printf(
                        /* translators: %s: link to Feeds section */
                        esc_html__( 'Add your first RSS feed in the %s', 'rss-newssync' ),
                        '<a href="#feeds" class="newssync-step-link">' . esc_html__( 'Feeds section', 'rss-newssync' ) . '</a>'
                    );
                    ?>
                </p>
            </div>
        </div>

        <div class="newssync-step">
            <div class="newssync-step-number">2</div>
            <div class="newssync-step-content">
                <p class="newssync-step-text">
                    <?php esc_html_e( 'Configure display settings and choose a layout', 'rss-newssync' ); ?>
                </p>
            </div>
        </div>

        <div class="newssync-step">
            <div class="newssync-step-number">3</div>
            <div class="newssync-step-content">
                <p class="newssync-step-text">
                    <?php
                    printf(
                        /* translators: %s: shortcode example */
                        esc_html__( 'Use the shortcode %s in any page or post', 'rss-newssync' ),
                        '<code>[newssync]</code>'
                    );
                    ?>
                </p>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="newssync-cards-grid">
        <div class="newssync-card">
            <div class="newssync-card-icon success">
                <span class="dashicons dashicons-rss"></span>
            </div>
            <p class="newssync-card-title"><?php esc_html_e( 'Active Feeds', 'rss-newssync' ); ?></p>
            <h3 class="newssync-card-value"><?php echo count( get_option( 'newssync_feeds', array() ) ); ?></h3>
        </div>

        <div class="newssync-card">
            <div class="newssync-card-icon primary">
                <span class="dashicons dashicons-layout"></span>
            </div>
            <p class="newssync-card-title"><?php esc_html_e( 'Default Layout', 'rss-newssync' ); ?></p>
            <h3 class="newssync-card-value"><?php echo esc_html( ucfirst( get_option( 'newssync_default_layout', 'grid' ) ) ); ?></h3>
        </div>

        <div class="newssync-card">
            <div class="newssync-card-icon warning">
                <span class="dashicons dashicons-clock"></span>
            </div>
            <p class="newssync-card-title"><?php esc_html_e( 'Cache Duration', 'rss-newssync' ); ?></p>
            <h3 class="newssync-card-value"><?php echo esc_html( get_option( 'newssync_cache_duration', '6h' ) ); ?></h3>
        </div>
    </div>
</div>
