<?php
/**
 * NewsSync Settings Section
 * Plugin configuration and settings management
 *
 * @package NewsSync
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Get settings from tabs file
$newssync_settings_file = dirname( __DIR__ ) . '/tabs/newssync-settings.php';
if ( file_exists( $newssync_settings_file ) ) {
    $newssync_fields = include $newssync_settings_file;
} else {
    $newssync_fields = array();
}
?>

<!-- Settings Section -->
<div class="newssync-content-section" data-section="settings" style="display:none;">
    <script>console.log('NewsSync: server included settings section');</script>

    <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" class="newssync-settings-form">
        <input type="hidden" name="action" value="newssync_save_settings">
        <?php wp_nonce_field( 'newssync_save_settings', 'newssync_nonce' ); ?>

        <table class="form-table" role="presentation">
            <tbody>
                <?php foreach ( $newssync_fields as $newssync_field ) : ?>
                    <?php
                    $newssync_field_id    = isset( $newssync_field['id'] ) ? $newssync_field['id'] : '';
                    $newssync_field_name  = isset( $newssync_field['name'] ) ? $newssync_field['name'] : '';
                    $newssync_field_desc  = isset( $newssync_field['desc'] ) ? $newssync_field['desc'] : '';
                    $newssync_field_type  = isset( $newssync_field['type'] ) ? $newssync_field['type'] : 'text';
                    $newssync_field_value = get_option( $newssync_field_id, isset( $newssync_field['default'] ) ? $newssync_field['default'] : '' );
                    ?>

                    <tr>
                        <th scope="row">
                            <label for="<?php echo esc_attr( $newssync_field_id ); ?>">
                                <?php echo esc_html( $newssync_field_name ); ?>
                            </label>
                        </th>
                        <td>
                            <?php if ( $newssync_field_type === 'select' && isset( $newssync_field['options'] ) ) : ?>
                                <select
                                    name="<?php echo esc_attr( $newssync_field_id ); ?>"
                                    id="<?php echo esc_attr( $newssync_field_id ); ?>"
                                    class="regular-text">
                                    <?php foreach ( $newssync_field['options'] as $newssync_opt_value => $newssync_opt_label ) : ?>
                                        <option
                                            value="<?php echo esc_attr( $newssync_opt_value ); ?>"
                                            <?php selected( $newssync_field_value, $newssync_opt_value ); ?>>
                                            <?php echo esc_html( $newssync_opt_label ); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>

                            <?php elseif ( $newssync_field_type === 'number' ) : ?>
                                <input
                                    type="number"
                                    name="<?php echo esc_attr( $newssync_field_id ); ?>"
                                    id="<?php echo esc_attr( $newssync_field_id ); ?>"
                                    value="<?php echo esc_attr( $newssync_field_value ); ?>"
                                    class="small-text"
                                    <?php if ( isset( $newssync_field['min'] ) ) echo 'min="' . esc_attr( $newssync_field['min'] ) . '"'; ?>
                                    <?php if ( isset( $newssync_field['max'] ) ) echo 'max="' . esc_attr( $newssync_field['max'] ) . '"'; ?>
                                    <?php if ( isset( $newssync_field['step'] ) ) echo 'step="' . esc_attr( $newssync_field['step'] ) . '"'; ?>>

                            <?php elseif ( $newssync_field_type === 'html' ) : ?>
                                <?php
                                // HTML blocks (e.g. Force Import Now card). Use the provided HTML key, fallback to content.
                                $newssync_html_block = isset( $newssync_field['html'] ) ? $newssync_field['html'] : ( $newssync_field['content'] ?? '' );

                                // Detect the auto-import card by the presence of the force-import button id.
                                $newssync_is_auto_import_card = ( strpos( $newssync_html_block, 'rsp-force-import-btn' ) !== false );
                                $newssync_save_as_posts       = get_option( 'newssync_save_as_posts', '0' );

                                // Only show the auto-import card when save-as-posts is enabled (legacy behavior preserved).
                                if ( ! $newssync_is_auto_import_card || '1' === (string) $newssync_save_as_posts ) {
                                    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                    echo $newssync_html_block;
                                }
                                ?>

                            <?php else : ?>
                                <input
                                    type="text"
                                    name="<?php echo esc_attr( $newssync_field_id ); ?>"
                                    id="<?php echo esc_attr( $newssync_field_id ); ?>"
                                    value="<?php echo esc_attr( $newssync_field_value ); ?>"
                                    class="regular-text">
                            <?php endif; ?>

                            <?php if ( ! empty( $newssync_field_desc ) ) : ?>
                                <p class="description"><?php echo esc_html( $newssync_field_desc ); ?></p>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <?php submit_button( __( 'Save Settings', 'rss-newssync' ) ); ?>
    </form>
</div>
