<?php
/**
 * NewsSync Tools Section
 * Database status, system information, and optimization tools
 *
 * @package NewsSync
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Get table stats
$newssync_table_stats = function_exists( 'newssync_get_table_stats' ) ? newssync_get_table_stats() : null;
$newssync_postmeta_count = function_exists( 'newssync_get_postmeta_count' ) ? newssync_get_postmeta_count() : 0;
$newssync_table_exists = function_exists( 'newssync_table_exists' ) && newssync_table_exists();
$newssync_last_error = get_option( 'newssync_last_table_error', '' );
$newssync_admin_post_url = admin_url( 'admin-post.php' );
?>

<!-- Tools Section -->
<div class="newssync-content-section" data-section="tools" style="display:none;">
    <script>console.log('NewsSync: server included tools section');</script>

    <h2><?php esc_html_e( 'Database Status', 'rss-newssync' ); ?></h2>

    <?php if ( $newssync_table_exists && $newssync_table_stats ) : ?>
        <table class="widefat" style="max-width: 800px; margin-top: 20px;">
            <thead>
                <tr>
                    <th><?php esc_html_e( 'Metric', 'rss-newssync' ); ?></th>
                    <th><?php esc_html_e( 'Value', 'rss-newssync' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><strong><?php esc_html_e( 'Optimized table exists', 'rss-newssync' ); ?></strong></td>
                    <td>
                        <?php if ( $newssync_table_exists ) : ?>
                            <span style="color: green;">✓ <?php esc_html_e( 'Yes', 'rss-newssync' ); ?></span>
                        <?php else : ?>
                            <span style="color: red;">✗ <?php esc_html_e( 'No', 'rss-newssync' ); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php if ( $newssync_table_exists ) : ?>
                <tr>
                    <td><strong><?php esc_html_e( 'Table name', 'rss-newssync' ); ?></strong></td>
                    <td><code><?php echo esc_html( function_exists( 'newssync_get_item_map_table_name' ) ? newssync_get_item_map_table_name() : '' ); ?></code></td>
                </tr>
                <?php endif; ?>
                <?php if ( $newssync_table_exists && $newssync_table_stats ) : ?>
                <tr>
                    <td><strong><?php esc_html_e( 'Records in optimized table', 'rss-newssync' ); ?></strong></td>
                    <td><strong><?php echo esc_html( number_format_i18n( $newssync_table_stats['rows'] ) ); ?></strong></td>
                </tr>
                <?php endif; ?>
                <tr>
                    <td><strong><?php esc_html_e( 'Table Size', 'rss-newssync' ); ?></strong></td>
                    <td><?php echo esc_html( $newssync_table_stats['size_mb'] ); ?> MB</td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e( 'Index Size', 'rss-newssync' ); ?></strong></td>
                    <td><?php echo esc_html( $newssync_table_stats['index_size_mb'] ); ?> MB</td>
                </tr>
                <?php if ( ! empty( $newssync_table_stats['created_at'] ) ) : ?>
                <tr>
                    <td><strong><?php esc_html_e( 'Created At', 'rss-newssync' ); ?></strong></td>
                    <td><?php echo esc_html( $newssync_table_stats['created_at'] ); ?></td>
                </tr>
                <?php endif; ?>
                <tr>
                    <td><strong><?php esc_html_e( 'Active Indexes', 'rss-newssync' ); ?></strong></td>
                    <td>
                        <?php
                        if ( ! empty( $newssync_table_stats['indexes'] ) ) {
                            echo esc_html( implode( ', ', array_keys( $newssync_table_stats['indexes'] ) ) );
                        } else {
                            esc_html_e( 'None', 'rss-newssync' );
                        }
                        ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e( 'Records in postmeta (fallback)', 'rss-newssync' ); ?></strong></td>
                    <td><?php echo esc_html( number_format_i18n( $newssync_postmeta_count ) ); ?></td>
                </tr>
                <?php if ( ! empty( $newssync_last_error ) ) : ?>
                <tr style="background:#ffe4e4;">
                    <td><strong><?php esc_html_e( 'Last DB error', 'rss-newssync' ); ?></strong></td>
                    <td style="max-width: 800px; word-break: break-word; color:#d00;">
                        <code><?php echo esc_html( $newssync_last_error ); ?></code>
                    </td>
                </tr>
                <?php endif; ?>
                <tr>
                    <td><strong><?php esc_html_e( 'WP‑CLI (migration)', 'rss-newssync' ); ?></strong></td>
                    <td><code>wp newssync migrate-item-map --batch=200</code></td>
                </tr>
            </tbody>
        </table>

    <?php else : ?>
        <div class="notice notice-warning inline" style="max-width: 800px; margin-top: 20px;">
            <p>
                <strong><?php esc_html_e( 'Optimized table not found', 'rss-newssync' ); ?></strong><br>
                <?php esc_html_e( 'The plugin is using legacy postmeta storage. For better performance, create the optimized table.', 'rss-newssync' ); ?>
            </p>
            <p>
                <?php
                printf(
                    /* translators: %s: number of postmeta entries */
                    esc_html__( 'Current postmeta entries: %s', 'rss-newssync' ),
                    esc_html( number_format_i18n( $newssync_postmeta_count ) )
                );
                ?>
            </p>
            <p>
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=rss-newssync-table-creation' ) ); ?>" class="button button-primary">
                    <?php esc_html_e( 'View Table Creation Guide', 'rss-newssync' ); ?>
                </a>
            </p>
        </div>
    <?php endif; ?>

    <hr style="margin: 40px 0;">

    <h2><?php esc_html_e( 'Actions', 'rss-newssync' ); ?></h2>
    <p>
        <?php if ( ! $newssync_table_exists ) : ?>
            <form method="post" action="<?php echo esc_url( $newssync_admin_post_url ); ?>" style="display:inline;">
                <?php wp_nonce_field( 'newssync_create_table' ); ?>
                <input type="hidden" name="action" value="newssync_create_table">
                <button class="button button-primary" type="submit">
                    <span class="dashicons dashicons-database-add" style="vertical-align: text-bottom;"></span>
                    <?php esc_html_e( 'Create Optimized Table', 'rss-newssync' ); ?>
                </button>
            </form>
            &nbsp;
            <button id="newssync-ajax-create" class="button">
                <span class="dashicons dashicons-update" style="vertical-align: text-bottom;"></span>
                <?php esc_html_e( 'Create via AJAX', 'rss-newssync' ); ?>
            </button>
            &nbsp;&nbsp;
        <?php endif; ?>

        <button id="newssync-clear-cache" class="button">
            <span class="dashicons dashicons-trash" style="vertical-align: text-bottom;"></span>
            <?php esc_html_e( 'Clear Cache', 'rss-newssync' ); ?>
        </button>

        &nbsp;

        <?php if ( ! empty( $newssync_last_error ) ) : ?>
            <button id="newssync-clear-error" class="button">
                <span class="dashicons dashicons-dismiss" style="vertical-align: text-bottom;"></span>
                <?php esc_html_e( 'Clear Error Log', 'rss-newssync' ); ?>
            </button>
            &nbsp;
        <?php endif; ?>

        <button id="newssync-dismiss-notice" class="button" data-nonce="<?php echo esc_attr( wp_create_nonce( 'newssync_dismiss_table_notice' ) ); ?>">
            <span class="dashicons dashicons-hidden" style="vertical-align: text-bottom;"></span>
            <?php esc_html_e( 'Dismiss notice for me', 'rss-newssync' ); ?>
        </button>
    </p>

    <div id="newssync-ajax-result" style="margin-top:16px;"></div>

    <hr style="margin: 40px 0;">

    <h2><?php esc_html_e( 'System Information', 'rss-newssync' ); ?></h2>
    <table class="widefat" style="max-width: 800px; margin-top: 20px;">
        <thead>
            <tr>
                <th><?php esc_html_e( 'Setting', 'rss-newssync' ); ?></th>
                <th><?php esc_html_e( 'Value', 'rss-newssync' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><strong><?php esc_html_e( 'PHP Version', 'rss-newssync' ); ?></strong></td>
                <td><?php echo esc_html( phpversion() ); ?></td>
            </tr>
            <tr>
                <td><strong><?php esc_html_e( 'WordPress Version', 'rss-newssync' ); ?></strong></td>
                <td><?php echo esc_html( get_bloginfo( 'version' ) ); ?></td>
            </tr>
            <tr>
                <td><strong><?php esc_html_e( 'MySQL Version', 'rss-newssync' ); ?></strong></td>
                <td><?php global $wpdb; echo esc_html( $wpdb->db_version() ); ?></td>
            </tr>
            <tr>
                <td><strong><?php esc_html_e( 'Max Execution Time', 'rss-newssync' ); ?></strong></td>
                <td><?php echo esc_html( ini_get( 'max_execution_time' ) ); ?>s</td>
            </tr>
            <tr>
                <td><strong><?php esc_html_e( 'Memory Limit', 'rss-newssync' ); ?></strong></td>
                <td><?php echo esc_html( ini_get( 'memory_limit' ) ); ?></td>
            </tr>
            <tr>
                <td><strong><?php esc_html_e( 'WP Memory Limit', 'rss-newssync' ); ?></strong></td>
                <td><?php echo esc_html( WP_MEMORY_LIMIT ); ?></td>
            </tr>
        </tbody>
    </table>

    <hr style="margin: 40px 0;">

    <h2><?php esc_html_e( 'Documentation', 'rss-newssync' ); ?></h2>
    <p>
        <button id="newssync-toggle-docs" class="button">
            <span class="dashicons dashicons-book" style="vertical-align: text-bottom;"></span>
            <?php esc_html_e( 'Show/Hide Installation Guide', 'rss-newssync' ); ?>
        </button>
    </p>

    <?php
    // Go up 3 levels: sections -> admin -> includes -> root
    $newssync_docs_file = dirname( __DIR__, 3 ) . '/docs/newssync-installation.md';
    $newssync_docs_exists = file_exists( $newssync_docs_file );
    $newssync_function_exists = function_exists( 'newssync_render_markdown_simple' );
    ?>

    <!-- Debug info (remove after testing) -->
    <script>
        console.log('NewsSync Debug:', {
            docsFile: '<?php echo esc_js( $newssync_docs_file ); ?>',
            fileExists: <?php echo $newssync_docs_exists ? 'true' : 'false'; ?>,
            functionExists: <?php echo $newssync_function_exists ? 'true' : 'false'; ?>,
            toggleBtn: document.getElementById('newssync-toggle-docs'),
            docsPanel: document.getElementById('newssync-docs-panel')
        });
    </script>

    <?php if ( $newssync_docs_exists ) : ?>
        <?php
        $newssync_md_content = file_get_contents( $newssync_docs_file ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_get_contents_file_get_contents
        if ( false !== $newssync_md_content && $newssync_function_exists ) :
            $newssync_rendered = newssync_render_markdown_simple( $newssync_md_content );
            ?>
            <div id="newssync-docs-panel" style="display:none; margin-top:20px; max-width:1100px; background:#f9f9f9; padding:20px; border:1px solid #ddd;">
                <h3><?php esc_html_e( 'Installation & Database Guide', 'rss-newssync' ); ?></h3>
                <?php
                // Already escaped in renderer.
                echo $newssync_rendered; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                ?>
            </div>
        <?php else : ?>
            <div class="notice notice-warning inline" style="margin-top:10px;">
                <p><?php esc_html_e( 'Documentation renderer not available.', 'rss-newssync' ); ?></p>
            </div>
        <?php endif; ?>
    <?php else : ?>
        <div class="notice notice-error inline" style="margin-top:10px;">
            <p><?php esc_html_e( 'Documentation file not found.', 'rss-newssync' ); ?></p>
        </div>
    <?php endif; ?>

</div>
