<?php
/**
 * Admin Tab: Settings
 * Main configuration fields
 */

if (! defined( 'ABSPATH' ) ) {
    exit;
}

// === Auto-import data (no <script> here) ===
 $newssync_cache_hours = (int) ( newssync_get_cache_duration() / HOUR_IN_SECONDS );
 $newssync_carousel_abs_max = 50; // hard upper bound (ajusta se preferires 30, 100, etc.)

/* translators: 1: number of hours (integer), 2: number of hours (integer). Both placeholders refer to hours until import/cache duration. */
 $newssync_auto_import_format = esc_html__( 'Automatic import active (from %1$d in %2$d hours)', 'rss-newssync' );
 $newssync_auto_import_text   = sprintf( $newssync_auto_import_format, $newssync_cache_hours, $newssync_cache_hours );

// Strings for JS (will be passed to JS with wp_json_encode in admin_footer)
 $newssync_nonce             = wp_create_nonce( 'newssync_force_import' );
// cria nonce para clear cache (usado pelo inline JS)
 $newssync_clear_cache_nonce = wp_create_nonce( 'newssync_clear_cache_action' );
 $newssync_importing_text    = __( 'Importing...', 'rss-newssync' );
 $newssync_error_import_text = __( 'Error during import', 'rss-newssync' );
 $newssync_timeout_msg_text  = __( 'Import timed out or error — check posts for results.', 'rss-newssync' );
 $newssync_force_label       = __( 'Force Import Now', 'rss-newssync' );

// Build only the HTML (no <script> tags) — plugin UI will render this HTML block.
// Keep it simple and avoid inline scripts here so sanitizers won't turn scripts into visible text.
ob_start();
?>
<div style="margin-top:20px; padding:15px; background:#e3fcec; border-left:4px solid #00d1b2; border-radius:4px;">
    <p style="margin:0 0 10px; font-weight:600; color:#006b5b;">
        <?php echo esc_html( $newssync_auto_import_text ); ?>
    </p>
    <p style="margin:0 0 15px; font-size:13px; color:#666;">
        <?php echo esc_html__( 'The import only runs when the feed cache expires or when you click the button below.', 'rss-newssync' ); ?>
    </p>
    <button type="button" id="rsp-force-import-btn" class="button button-primary">
        <?php echo esc_html__( 'Force Import Now', 'rss-newssync' ); ?>
    </button>
    <p id="rsp-import-status" style="margin-top:10px; font-size:13px;"></p>
</div>
<?php
$newssync_html_block = ob_get_clean();

$newssync_auto_import_field = [
    'type' => 'html',
    'html' => $newssync_html_block,
];


return [

    // === DEFAULT LAYOUT ===
    [
        'id'      => 'newssync_default_layout',
        'name'    => __( 'Default Layout', 'rss-newssync' ),
        'desc'    => __( 'Choose the default layout for the shortcode when no layout is specified.', 'rss-newssync' ),
        'type'    => 'select',
        'options' => [
            'grid'     => __( 'Grid', 'rss-newssync' ),
            'list'     => __( 'List', 'rss-newssync' ),
            'carousel' => __( 'Carousel', 'rss-newssync' ),
            'hero'     => __( 'Hero (Featured)', 'rss-newssync' ),
        ],
        'default' => 'grid',
    ],

     // === DEFAULT LIST MODE ===
    [
        'id'      => 'newssync_list_mode',
        'name'    => __( 'Default List Mode', 'rss-newssync' ),
        'desc'    => __( 'Choose the default style for List layout. Can be overridden in shortcode.', 'rss-newssync' ),
        'type'    => 'select',
        'options' => [
            'standard' => __( 'Standard (with image and text)', 'rss-newssync' ),
            'minimal'  => __( 'Minimal (title + time only)', 'rss-newssync' ),
            'custom'   => __( 'Custom (use shortcode parameters)', 'rss-newssync' ),
        ],
        'default' => 'standard',
    ],

    // === HERO: MAX ITEMS (limited in this distribution) ===
    [
        'id'      => 'newssync_hero_max_items',
        'name'    => __( 'Hero Carousel: Max Items', 'rss-newssync' ),
        'desc'    => __( 'Maximum number of items in Hero/Carousel layout. Limited to 6 by default.', 'rss-newssync' ),
        'type'    => 'select',
        'options' => [ '1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6' ],
        'default' => '6',
    ],

    // === SHOW IMAGES ===
    [
        'id'      => 'newssync_show_image',
        'name'    => __( 'Show Images', 'rss-newssync' ),
        'desc'    => __( 'Display featured images in the feed.', 'rss-newssync' ),
        'type'    => 'select',
        'options' => [
            '1' => __( 'Yes', 'rss-newssync' ),
            '0' => __( 'No', 'rss-newssync' ),
        ],
        'default' => '1',
    ],

    // === CACHE DURATION ===
    [
        'id'      => 'newssync_cache_duration',
        'name'    => __( 'Cache Duration', 'rss-newssync' ),
        'desc'    => __( 'How long to cache RSS feeds.', 'rss-newssync' ),
        'type'    => 'select',
        'options' => [
            '6h'  => __( '6 Hours', 'rss-newssync' ),
            '24h' => __( '24 Hours', 'rss-newssync' ),
        ],
        'default' => '6h',
    ],


    // === SAVE RSS ITEMS AS POSTS ===
    [
        'id'      => 'newssync_save_as_posts',
        'name'    => __( 'Save RSS Items as Posts', 'rss-newssync' ),
        'desc'    => sprintf(
            '%1$s<br>%2$s<br><span style="color:#d63638;">%3$s</span>',
            esc_html__( 'Each RSS news item will be saved as a WordPress post when the shortcode runs on a page.', 'rss-newssync' ),
            sprintf(
                /* translators: %s: the shortcode tag */
                esc_html__( 'Add %s to any page to start importing.', 'rss-newssync' ),
                '<code>[newssync]</code>'
            ),
            esc_html__( 'Not automatic — runs only when page is viewed.', 'rss-newssync' )
        ),
        'type'    => 'select',
        'options' => [
            '1' => __( 'Yes', 'rss-newssync' ),
            '0' => __( 'No', 'rss-newssync' ),
        ],
        'default' => '0',
    ],


    // === BUTTON: OPEN FEED PAGE & IMPORT NOW (WITH AJAX) ===
    $newssync_auto_import_field,

    // === POST STATUS ===
    [
        'id'      => 'newssync_publish_status',
        'name'    => __( 'Post Status', 'rss-newssync' ),
        'desc'    => __( 'Choose if new RSS posts are published immediately or saved as draft.', 'rss-newssync' ),
        'type'    => 'select',
        'options' => [
            'publish' => __( 'Publish', 'rss-newssync' ),
            'draft'   => __( 'Draft', 'rss-newssync' ),
        ],
        'default' => 'publish',
    ],


    // NOTE: 'Max Items per Import', 'Duplicate Similarity Threshold' and
    // 'Show Read More Link' settings removed from free distribution.

];
