(function(){
    function capSwiperDots(maxDots) {
        if (!maxDots || typeof maxDots !== 'number' || maxDots <= 0) return;
        var wrappers = document.querySelectorAll('.rsp-carousel, .rsp-hero');
        wrappers.forEach(function(wrapper){
            var dotsContainer = wrapper.querySelector('.swiper-pagination');
            if (!dotsContainer) return;
            var dots = dotsContainer.querySelectorAll('.swiper-pagination-bullet');
            if (!dots || dots.length <= maxDots) return;

            // hide extra dots
            for (var i = maxDots; i < dots.length; i++) {
                dots[i].style.display = 'none';
            }

            // add "+N" indicator if not already present
            if (!dotsContainer.querySelector('.rsp-dots-more')) {
                var more = document.createElement('span');
                more.className = 'rsp-dots-more';
                more.textContent = '+' + (dots.length - maxDots);
                more.style.marginLeft = '8px';
                more.style.fontSize = '0.9em';
                more.style.color = '#444';
                dotsContainer.appendChild(more);
            }
        });
    }

    // exposer function globally
    window.rspCapSwiperDots = capSwiperDots;

    // run on DOM ready and after a short delay (Swiper init)
    document.addEventListener('DOMContentLoaded', function(){
        setTimeout(function(){
            // sensible default if not called with inline param
            capSwiperDots(12);
        }, 600);
    });
})();