<?php
/**
 * Bootstrap do plugin
 */
if (!defined('ABSPATH')) exit;

// === CONSTANTES GLOBAIS (fallback robusto) ===
if ( ! defined( 'NEWSSYNC_PLUGIN_PATH' ) ) {
    // Best-effort fallback: use plugin_dir_path pointing to the main plugin file
    $newssync_main_file = dirname( __DIR__, 2 ) . '/rss-newssync.php';
    if ( file_exists( $newssync_main_file ) ) {
        define( 'NEWSSYNC_PLUGIN_PATH', plugin_dir_path( $newssync_main_file ) );
    } else {
        // Use plugin_dir_path as a safer fallback even if main file not found
        define( 'NEWSSYNC_PLUGIN_PATH', plugin_dir_path( __DIR__ . '/../../rss-newssync.php' ) );
    }
}

// Define NEWSSYNC_PLUGIN_DIR as filesystem directory constant (alias to PATH)
if ( ! defined( 'NEWSSYNC_PLUGIN_DIR' ) ) {
    define( 'NEWSSYNC_PLUGIN_DIR', NEWSSYNC_PLUGIN_PATH );
}

if ( ! defined( 'NEWSSYNC_PLUGIN_URL' ) ) {
    $newssync_main_file = dirname( __DIR__, 2 ) . '/rss-newssync.php';
    if ( file_exists( $newssync_main_file ) ) {
        define( 'NEWSSYNC_PLUGIN_URL', plugin_dir_url( $newssync_main_file ) );
    } else {
        define( 'NEWSSYNC_PLUGIN_URL', plugin_dir_url( __DIR__ . '/../../rss-newssync.php' ) );
    }
}

// Ensure DIR present after URL fallback too
if ( ! defined( 'NEWSSYNC_PLUGIN_DIR' ) ) {
    define( 'NEWSSYNC_PLUGIN_DIR', NEWSSYNC_PLUGIN_PATH );
}

// === HELPERS ===
if (file_exists(NEWSSYNC_PLUGIN_PATH . 'includes/core/helpers/newssync-items.php')) {
    require_once NEWSSYNC_PLUGIN_PATH . 'includes/core/helpers/newssync-items.php';
}
if (file_exists(NEWSSYNC_PLUGIN_PATH . 'includes/core/helpers/newssync-save-posts.php')) {
    require_once NEWSSYNC_PLUGIN_PATH . 'includes/core/helpers/newssync-save-posts.php';
}
// Load DB helpers
if ( file_exists( NEWSSYNC_PLUGIN_PATH . 'includes/core/newssync-db.php' ) ) {
    require_once NEWSSYNC_PLUGIN_PATH . 'includes/core/newssync-db.php';
}

// === SHORTCODE (frontend only) ===
if (!is_admin() && file_exists(NEWSSYNC_PLUGIN_PATH . 'includes/core/newssync-shortcode.php')) {
    require_once NEWSSYNC_PLUGIN_PATH . 'includes/core/newssync-shortcode.php';
}

// === ADMIN ===
if (is_admin() && file_exists(NEWSSYNC_PLUGIN_PATH . 'includes/admin/newssync-settings-page.php')) {
    require_once NEWSSYNC_PLUGIN_PATH . 'includes/admin/newssync-settings-page.php';
    // Add admin menu only if function exists in settings-page
    if (function_exists('newssync_add_admin_menu')) {
        add_action('admin_menu', 'newssync_add_admin_menu');
    }
    // Add docs submenu (settings-page handles this)
}

// WP-CLI tools (migration) — load only when present
if ( defined( 'WP_CLI' ) && WP_CLI && file_exists( NEWSSYNC_PLUGIN_PATH . 'includes/core/newssync-cli-migrate.php' ) ) {
    require_once NEWSSYNC_PLUGIN_PATH . 'includes/core/newssync-cli-migrate.php';
}

// Prune feature removed for WordPress.org distribution.
// The Prune implementation and admin pages were removed to comply with
// free-plugin requirements; no prune files are loaded.

// name=includes/core/bootstrap.php (apenas a linha a adicionar)
if ( file_exists( __DIR__ . '/request-helpers.php' ) ) {
    require_once __DIR__ . '/request-helpers.php';
}


// === ENQUEUE ASSETS ===
add_action('wp_enqueue_scripts', 'newssync_enqueue_frontend');
add_action('admin_enqueue_scripts', 'newssync_enqueue_admin');

function newssync_enqueue_frontend() {
    if (is_admin()) return;
    // Enfileira CSS global do plugin (frontend)
    if (file_exists(NEWSSYNC_PLUGIN_PATH . 'includes/assets/css/frontend.css')) {
        wp_enqueue_style(
            'rsp-frontend',
            NEWSSYNC_PLUGIN_URL . 'includes/assets/css/frontend.css',
            [],
            '1.0.0'
        );
    }
}

function newssync_enqueue_admin($hook) {
    // Só charger scripts no admin quando estiver na página do plugin
    // Alguns hooks podem variar, por isso verificamos se o hook contém nossas strings
    if (strpos($hook, 'rss-newssync') === false && strpos($hook, 'rss-newssync-feeds') === false && strpos($hook, 'rss-newssync-settings') === false) {
        return;
    }

    // CSS do admin
    if (file_exists(NEWSSYNC_PLUGIN_PATH . 'includes/assets/css/admin.css')) {
        wp_enqueue_style(
            'rsp-admin-css',
            NEWSSYNC_PLUGIN_URL . 'includes/assets/css/admin.css',
            [],
            '1.0.0'
        );
    }

    // JS do admin (Drag & Drop Feeds)
    if (file_exists(NEWSSYNC_PLUGIN_PATH . 'includes/assets/js/admin-feeds.js')) {
        wp_enqueue_script(
            'rsp-admin-feeds',
            NEWSSYNC_PLUGIN_URL . 'includes/assets/js/admin-feeds.js',
            ['jquery'],
            '1.0.1',
            true
        );
    }
}
