<?php
if (!defined('ABSPATH')) exit;

function newssync_get_display_parts($atts) {
    $list_mode_from_shortcode = $atts['list_mode'] ?? '';
    $list_mode = $list_mode_from_shortcode ?: get_option('newssync_list_mode', 'standard');

    // Defaults standard e minimal (mantém como tinhas)
    $defaults = [
        'standard' => [
            'title' => true, 'image' => true, 'excerpt' => true, 'date' => true,
            'source' => false, 'readmore' => false, 'compact' => false,
            'date_format' => 'H:i - d/m', 'excerpt_length' => 25,
        ],
        'minimal' => [
            'title' => true, 'image' => false, 'excerpt' => false, 'date' => true,
            'source' => true, 'readmore' => false, 'compact' => true,
            'date_format' => 'd/m/Y H:i', 'excerpt_length' => 0,
        ],
    ];

    // FORÇA MODO CUSTOM se vier no shortcode ou se admin = custom e não houver override
    $is_custom = ($list_mode_from_shortcode === 'custom') || ($list_mode === 'custom' && $list_mode_from_shortcode === '');

    if ($is_custom) {
        $config = [
            'title'         => ($atts['show_title'] ?? 'yes') === 'yes',
            'image'         => ($atts['show_image'] ?? 'yes') === 'yes',
            'excerpt'       => ($atts['show_excerpt'] ?? 'yes') === 'yes',
            'date'          => ($atts['show_date'] ?? 'yes') === 'yes',
            'source'        => ($atts['show_source'] ?? 'yes') === 'yes',
            'readmore'      => ($atts['show_readmore'] ?? 'no') === 'yes',
            'compact'       => ($atts['compact'] ?? 'no') === 'yes',
            'date_format'   => $atts['date_format'] ?? 'H:i - d/m',
            'excerpt_length'=> min(intval($atts['excerpt_length'] ?? 25), 25), // Limite free
        ];

        // Só mostra teaser se usar parâmetros avançados ou tentar excerpt > 25
        $config['pro_teaser'] = false;
        if ((intval($atts['excerpt_length'] ?? 0) > 25) || !empty($atts['title_length']) || !empty($atts['keyword_filter'])) {
            $config['pro_teaser'] = true;
        }

    } else {
        $config = $defaults[$list_mode] ?? $defaults['standard'];
        $config['pro_teaser'] = false;
    }

    return $config;
}
