<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Register Swiper assets (styles & scripts) if local files exist.
 * Assets expected in: rss-newssync/includes/assets/vendor/swiper/
 * This function only registers the handles; enqueueing happens condicionalmente
 * onde o shortcode/layout decidir (shortcode.php).
 */
function newssync_register_swiper_assets() {
    // Filesystem path to includes/assets/vendor/swiper/
    $assets_dir = __DIR__ . '/../assets/vendor/swiper/';

    if ( defined( 'NEWSSYNC_PLUGIN_URL' ) ) {
        $assets_url = NEWSSYNC_PLUGIN_URL . 'includes/assets/vendor/swiper/';
    } else {
        $assets_url = plugin_dir_url( __DIR__ . '/../../rss-newssync.php' ) . 'includes/assets/vendor/swiper/';
    }

    $css_file  = $assets_dir . 'swiper-bundle.min.css';
    $js_file   = $assets_dir . 'swiper-bundle.min.js';
    $init_file = $assets_dir . 'rsp-swiper-init.js';

    if ( file_exists( $css_file ) ) {
        wp_register_style( 'swiper-css', $assets_url . 'swiper-bundle.min.css', array(), filemtime( $css_file ) );
    }

    if ( file_exists( $js_file ) ) {
        wp_register_script( 'swiper-js', $assets_url . 'swiper-bundle.min.js', array(), filemtime( $js_file ), true );
    }

    if ( file_exists( $init_file ) ) {
        wp_register_script( 'rsp-swiper-init', $assets_url . 'rsp-swiper-init.js', array( 'swiper-js' ), filemtime( $init_file ), true );
    }
}
add_action( 'wp_enqueue_scripts', 'newssync_register_swiper_assets', 5 );
