<?php
if (!defined('ABSPATH')) exit;

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
// This template intentionally uses legacy contract variables provided by the shortcode
// (`$newssync_atts`, `$newssync_display`, `$items`, `$item`). Renaming these would
// break includes; keep them and suppress the specific PHPCS rule for this file.
global $newssync_atts, $newssync_display;

// Ensure variables
$atts = is_array($newssync_atts) ? $newssync_atts : [];
$display = is_array($newssync_display) ? $newssync_display : [];
$items = is_array($items) ? $items : [];

/**
 * Safe hero limit logic:
 * - If the user explicitly provided limit in the shortcode, respect it (min 1).
 * - If not provided, use the option newssync_hero_max_items but enforce a sensible minimum (3)
 *   to avoid the plugin option accidentally being set to 1 and leaving the slider with one slide.
 */
$provided_limit = (isset($atts['limit']) && $atts['limit'] !== '') ? intval($atts['limit']) : null;
$option_limit = (int) get_option('newssync_hero_max_items', 6);

if ( $provided_limit !== null ) {
    $limit = max(1, min(18, $provided_limit));
} else {
    // Use option but avoid very small values when no explicit limit was provided.
    $limit = $option_limit > 0 ? $option_limit : 6;
$limit = max(3, min(18, $limit)); // ensure sensible default minimum of 3
}

$items_count_before = count($items);
if ( $limit > 0 && $items_count_before > $limit ) {
    $items = array_slice($items, 0, $limit);
}

if ( empty( $items ) ) {
    echo '<p style="text-align:center;color:#666;">' . esc_html__( 'No items to display.', 'rss-newssync' ) . '</p>';
    return;
}

// Prefer templates if exist
$newssync_hero_open = NEWSSYNC_PLUGIN_DIR . 'includes/templates/hero/hero-container-open.php';
$newssync_hero_item_tpl = NEWSSYNC_PLUGIN_DIR . 'includes/templates/hero/hero-item.php';
$newssync_hero_close = NEWSSYNC_PLUGIN_DIR . 'includes/templates/hero/hero-container-close.php';

if ( file_exists( $newssync_hero_open ) ) {
    include $newssync_hero_open;
} else {
    echo '<div class="rsp-container"><div class="swiper rsp-hero"><div class="swiper-wrapper">';
}

foreach ( (array) $items as $item ):
    if ( file_exists( $newssync_hero_item_tpl ) ) {
        include $newssync_hero_item_tpl;
    } else {
        // Fallback slide
        $title = $item['title'] ?? '';
        $link = $item['link'] ?? '#';
        $img  = $item['img'] ?? '';
        $style_attr = $img ? ' style="background-image:url(' . esc_url($img) . ');"' : '';
        echo '<div class="swiper-slide rsp-hero-slide"' . ( ! empty( $style ) ? ' style="' . esc_attr( $style ) . '"' : '' ) . '><div class="rsp-hero-overlay"><h3><a class="rsp-no-underline" href="' . esc_url( $link ) . '" target="_blank" rel="noopener noreferrer">' . esc_html( $title ) . '</a></h3></div></div>';
    }
endforeach;

if ( file_exists( $newssync_hero_close ) ) {
    include $newssync_hero_close;
} else {
    echo '</div><div class="swiper-button-next"></div><div class="swiper-button-prev"></div><div class="swiper-pagination"></div></div></div>';
}
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
