<?php
if (!defined('ABSPATH')) exit;

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
// This template uses the legacy rendering contract variables provided by the shortcode
// (`$newssync_display`, `$atts`, `$items`, `$item`). Renaming them would break includes.
global $newssync_display, $atts;

// Garantias e defaults
$display = is_array($newssync_display) ? $newssync_display : [];
$atts = is_array($atts) ? $atts : [];

$display_defaults = [
    'compact'        => false,
    'image'          => true,
    'title'          => true,
    'date'           => true,
    'source'         => false,
    'excerpt'        => true,
    'excerpt_length' => 25,
    'readmore'       => false,
    'date_format'    => $display['date_format'] ?? 'H:i - d/m',
    'list_mode'      => $display['list_mode'] ?? get_option('newssync_list_mode', 'standard'),
];
$display = wp_parse_args($display, $display_defaults);

// Items safe
$items = is_array($items) ? $items : [];

// Container classes
 $newssync_container_class = ! empty( $display['compact'] ) ? 'rsp-compact' : '';
?>
<div class="rsp-container <?php echo esc_attr( $newssync_container_class ); ?>">
    <div class="rsp-list">
        <?php if ( empty( $items ) ): ?>
            <p class="rsp-no-items"><?php echo esc_html__( 'No items to display.', 'rss-newssync' ); ?></p>
        <?php endif; ?>

        <?php foreach ( (array) $items as $item ):
            $newssync_title    = $item['title'] ?? '';
            $newssync_link     = $item['link'] ?? '#';
            $newssync_img      = $item['img'] ?? '';
            $newssync_date_raw = $item['date'] ?? '';
            $newssync_category = $item['category'] ?? '';
            $newssync_source_name = $item['source_name'] ?? '';
            $newssync_source_url = $item['source_url'] ?? '';
            $newssync_desc     = $item['desc'] ?? '';

            // Decide what to show (respect display flags and list_mode fallback)
            $newssync_always_show_source = ( $display['list_mode'] ?? get_option('newssync_list_mode', 'standard') ) === 'standard';
            $newssync_show_date = !empty($display['date']);
            $newssync_show_source = !empty($display['source']) || $newssync_always_show_source;
        ?>
            <div class="rsp-list-item <?php echo ! empty( $display['compact'] ) ? 'rsp-compact-item' : ''; ?>">

                <?php if ( ! empty( $display['image'] ) && ! empty( $newssync_img ) ): ?>
                    <div class="rsp-list-image">
                            <a class="rsp-no-underline" href="<?php echo esc_url( $newssync_link ); ?>" target="_blank" rel="noopener noreferrer">
                            <img src="<?php echo esc_url( $newssync_img ); ?>" alt="<?php echo esc_attr( $newssync_title ); ?>" loading="lazy" decoding="async">
                        </a>
                    </div>
                <?php endif; ?>

                <div class="rsp-list-content">
                    <?php if ( ! empty( $display['title'] ) ): ?>
                        <h3 class="rsp-list-title">
                            <a class="rsp-no-underline" href="<?php echo esc_url( $newssync_link ); ?>" target="_blank" rel="noopener noreferrer">
                                <?php echo esc_html( $newssync_title ); ?>
                            </a>
                        </h3>
                    <?php endif; ?>

                    <?php if ( $newssync_show_date || $newssync_show_source ): ?>
                        <p class="rsp-list-meta">
                            <?php
                            // Print date only if allowed
                            $newssync_printed_date = false;
                            if ( $newssync_show_date ) {
                                if ( ! empty( $newssync_date_raw ) ) {
                                    echo esc_html( $newssync_date_raw );
                                    $newssync_printed_date = true;
                                } else {
                                    $ts = strtotime( $newssync_date_raw );
                                    if ( $ts ) {
                                        echo esc_html( date_i18n( $display['date_format'], $ts ) );
                                        $newssync_printed_date = true;
                                    }
                                }
                            }

                            // Print source only if allowed; add separator if date was printed
                            if ( $newssync_show_source ) {
                                if ( $newssync_printed_date ) echo ' - ';
                                // Mostrar source_name se disponível, senão category
                                if ( ! empty( $newssync_source_name ) ) {
                                    ?>
                                    <span class="rsp-source-name">
                                        <?php if ( ! empty( $newssync_source_url ) ) : ?>
                                            <a href="<?php echo esc_url( $newssync_source_url ); ?>"
                                               target="_blank"
                                               rel="noopener noreferrer"
                                               <?php /* translators: %s: source name */ ?>
                                               title="<?php echo esc_attr( sprintf( __( 'Visit %s', 'rss-newssync' ), $newssync_source_name ) ); ?>">
                                                <?php echo esc_html( $newssync_source_name ); ?>
                                            </a>
                                        <?php else : ?>
                                            <?php echo esc_html( $newssync_source_name ); ?>
                                        <?php endif; ?>
                                    </span>
                                    <?php
                                } elseif ( ! empty( $newssync_category ) ) {
                                    ?>
                                    <span class="rsp-item-source"><?php echo esc_html( $newssync_category ); ?></span>
                                    <?php
                                }
                            } ?>
                        </p>
                    <?php endif; ?>

                    <?php if ( ! empty( $display['excerpt'] ) && ! empty( $newssync_desc ) ):
                        // Render excerpt respecting excerpt_length and FREE cap
                        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- legacy display contract
                        global $newssync_display;
                        $newssync_raw_excerpt = ! empty( $item['desc'] ) ? $item['desc'] : ( ! empty( $item['desc_raw'] ) ? $item['desc_raw'] : ( ! empty( $item['description'] ) ? wp_strip_all_tags( $item['description'] ) : '' ) );

                        $newssync_len = isset( $newssync_display['excerpt_length'] ) ? intval( $newssync_display['excerpt_length'] ) : 25;
                        if ( $newssync_len < 0 ) $newssync_len = 0;
                        $newssync_max_allowed = 25;
                        $newssync_len = min( $newssync_len, $newssync_max_allowed );

                        $newssync_excerpt = $newssync_len > 0 && $newssync_raw_excerpt !== '' ? wp_trim_words( $newssync_raw_excerpt, $newssync_len, '…' ) : '';
                    ?>
                        <p class="rsp-list-desc">
                            <?php echo esc_html( $newssync_excerpt ); ?>

                            <?php if ( get_option('newssync_show_readmore', 'yes') === 'yes' && ! empty( $display['readmore'] ) ): ?>
                                <a class="rsp-no-underline rsp-read-more" href="<?php echo esc_url( $newssync_link ); ?>" target="_blank" rel="noopener noreferrer">
                                    <?php echo esc_html__( 'Read more', 'rss-newssync' ); ?>
                                </a>
                            <?php endif; ?>
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>
