<?php if (!defined('ABSPATH')) exit; ?>
<?php // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- legacy display contract
global $newssync_display; ?>
<div class="rsp-card">
    <?php if (!empty($item['img']) && $atts['show_image']): ?>
        <img decoding="async" src="<?php echo esc_url($item['img']); ?>" alt="<?php echo esc_attr($item['title']); ?>">
    <?php endif; ?>

    <div class="rsp-card-content">
        <h3 class="rsp-card-title">
            <a class="rsp-no-underline" href="<?php echo esc_url($item['link']); ?>" target="_blank" rel="noopener">
                <?php echo esc_html($item['title']); ?>
            </a>
        </h3>
        <p class="rsp-card-date">
            <?php echo esc_html($item['date']); ?>
            <?php if ( ! empty( $item['source_name'] ) ) : ?>
                - <span class="rsp-source-name">
                    <?php if ( ! empty( $item['source_url'] ) ) : ?>
                        <a href="<?php echo esc_url( $item['source_url'] ); ?>"
                           target="_blank"
                           rel="noopener noreferrer"
                           <?php /* translators: %s: source name */ ?>
                           title="<?php echo esc_attr( sprintf( __( 'Visit %s', 'rss-newssync' ), $item['source_name'] ) ); ?>">
                            <?php echo esc_html( $item['source_name'] ); ?>
                        </a>
                    <?php else : ?>
                        <?php echo esc_html( $item['source_name'] ); ?>
                    <?php endif; ?>
                </span>
            <?php elseif ( ! empty( $item['category'] ) ) : ?>
                - <?php echo esc_html($item['category']); ?>
            <?php endif; ?>
        </p>

        <?php
        // Excerpt rendering similar to grid/list
        $newssync_raw_excerpt = '';
        if (!empty($item['desc'])) {
            $newssync_raw_excerpt = $item['desc'];
        } elseif (!empty($item['desc_raw'])) {
            $newssync_raw_excerpt = $item['desc_raw'];
        } elseif (!empty($item['description'])) {
            $newssync_raw_excerpt = wp_strip_all_tags($item['description']);
        }

        $newssync_len = isset($newssync_display['excerpt_length']) ? intval($newssync_display['excerpt_length']) : 25;
        if ($newssync_len < 0) $newssync_len = 0;
        $newssync_max_allowed = 25;
        $newssync_len = min($newssync_len, $newssync_max_allowed);
        $newssync_excerpt_trimmed = $newssync_len > 0 && $newssync_raw_excerpt !== '' ? wp_trim_words( $newssync_raw_excerpt, $newssync_len, '…' ) : '';
        ?>

        <?php if ($newssync_excerpt_trimmed !== ''): ?>
            <p class="rsp-card-desc"><?php echo esc_html($newssync_excerpt_trimmed); ?>
                <?php if (get_option('newssync_show_readmore', 'yes') === 'yes'): ?>
                    <a class="rsp-no-underline" href="<?php echo esc_url($item['link']); ?>" target="_blank" rel="noopener">[Read more]</a>
                <?php endif; ?>
            </p>
        <?php else: ?>
            <?php if (get_option('newssync_show_readmore', 'yes') === 'yes'): ?>
                <p class="rsp-card-desc">
                    <a class="rsp-no-underline" href="<?php echo esc_url($item['link']); ?>" target="_blank" rel="noopener">[Read more]</a>
                </p>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>
