<?php if (!defined('ABSPATH')) exit;

if (!isset($item)) return;
$newssync_hero_image_url = $item['img'] ?? '';
$newssync_hero_source_name = $item['source_name'] ?? '';
?>
<div class="swiper-slide rsp-hero-slide" style="background-image: url('<?php echo esc_url($newssync_hero_image_url); ?>')">
    <div class="rsp-hero-overlay">
        <h3 class="rsp-hero-title">
            <a class="rsp-no-underline" href="<?php echo esc_url($item['link']); ?>" target="_blank" rel="noopener">
                <?php echo esc_html($item['title']); ?>
            </a>
        </h3>
        <p class="rsp-hero-date">
            <?php echo esc_html($item['date']); ?>
            <?php if ( ! empty( $newssync_hero_source_name ) ) : ?>
                - <span class="rsp-source-name">
                    <?php if ( ! empty( $item['source_url'] ) ) : ?>
                        <a href="<?php echo esc_url( $item['source_url'] ); ?>"
                           target="_blank"
                           rel="noopener noreferrer"
                           <?php /* translators: %s: source name */ ?>
                           title="<?php echo esc_attr( sprintf( __( 'Visit %s', 'rss-newssync' ), $newssync_hero_source_name ) ); ?>">
                            <?php echo esc_html( $newssync_hero_source_name ); ?>
                        </a>
                    <?php else : ?>
                        <?php echo esc_html( $newssync_hero_source_name ); ?>
                    <?php endif; ?>
                </span>
            <?php elseif ( ! empty( $item['category'] ) ) : ?>
                - <?php echo esc_html($item['category']); ?>
            <?php endif; ?>
        </p>
        <?php if (get_option('newssync_show_readmore', 'yes') === 'yes'): ?>
            <p class="rsp-hero-readmore">
                <a class="rsp-no-underline" href="<?php echo esc_url($item['link']); ?>" target="_blank" rel="noopener">
                    <?php echo esc_html__('Read More', 'rss-newssync'); ?>
                </a>
            </p>
        <?php endif; ?>
    </div>
</div>
